USE OLAP
--Online sales
SELECT distinct order_method_type
FROM sales

--Online order method types would be E-mail, Mail and Web.
--In person would be Telephone and Sales visit.

--The calculation would then be 
--'CASE WHEN order_method_type IN ('E-mail','Mail','Web') THEN 'Online' ELSE 'In Person'

SELECT --dimensions
       order_method_type
	   ,CASE WHEN order_method_type IN ('E-mail','Mail','Web') THEN 'Yes' 
	        ELSE 'No'
	   END as online --don't forget to add it to the group by clause
	   ,retailer_type 

       --measures for sale price
	   ,min(sale_price) as min_sale_price
	   ,max(sale_price) as max_sale_price
	   ,avg(sale_price) as average_sale_price

	   --measures for quantity sold
       ,sum(quantity_sold) as number_sold
	   ,count(quantity_sold) as number_of_sales 

FROM sales
GROUP BY order_method_type,retailer_type
         ,CASE WHEN order_method_type IN ('E-mail','Mail','Web') THEN 'Yes' 
	        ELSE 'No'
	      END --always group by dimensions